package ch.frankel.blog.validation.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.apache.commons.lang.WordUtils;

/**
 * Checks that a String is capitalized.
 * 
 * @author <a href="http://blog.frankel.ch">Nicolas Frankel</a>
 */
public class CapitalizedValidator implements
		ConstraintValidator<Capitalized, String> {

	/**
	 * @see javax.validation.ConstraintValidator#initialize(java.lang.annotation.Annotation)
	 */
	public void initialize(Capitalized capitalized) {

		// NOTHING TO DO
	}

	/**
	 * @see javax.validation.ConstraintValidator#isValid(java.lang.Object,
	 *      javax.validation.ConstraintValidatorContext)
	 */
	public boolean isValid(String value, ConstraintValidatorContext context) {

		return value == null || value.equals(WordUtils.capitalizeFully(value));
	}
}
